﻿<%@ Page Language="VB" AutoEventWireup="false" CodeFile="Default.aspx.vb" Inherits="_Default" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link rel="stylesheet" href ="StyleSheet/Main.css">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <h1>User Account Creation</h1>
            <p>
                Last Name:
                <asp:TextBox ID="txtLastName" runat="server" CssClass="Validation"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RFVLastName" runat="server" ControlToValidate="txtLastName" CssClass="Validation" Display="None" ErrorMessage="Last Name Required" SetFocusOnError="True"></asp:RequiredFieldValidator>
            </p>
            <p>
                First Name:
                <asp:TextBox ID="txtFirstName" runat="server" CssClass="Validation"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RFVFirstName" runat="server" ControlToValidate="txtFirstName" CssClass="Validation" Display="None" ErrorMessage="First Name Required" SetFocusOnError="True"></asp:RequiredFieldValidator>
            </p>
            <p>
                Date of Birth:
                <asp:TextBox ID="txtDateofBirth" runat="server" CssClass="Validation"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RFVDOB" runat="server" ControlToValidate="txtDateofBirth" CssClass="Validation" Display="None" ErrorMessage="Date of Birth Required" SetFocusOnError="True"></asp:RequiredFieldValidator>
                <asp:RangeValidator ID="RVDOB" runat="server" ControlToValidate="txtDateofBirth" CssClass="Validation" Display="None" ErrorMessage="Enter a Date between 1-1-1955 to 12-31-1995 Please" MaximumValue="12/31/1995" MinimumValue="1/1/1955" SetFocusOnError="True"></asp:RangeValidator>
            </p>
            <p>
                User ID:
                <asp:TextBox ID="txtUserID" runat="server" CssClass="Validation"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RFVUserid" runat="server" ControlToValidate="txtUserID" CssClass="Validation" Display="None" ErrorMessage="UserID Required" SetFocusOnError="True"></asp:RequiredFieldValidator>
                <asp:CustomValidator ID="CVUserID" runat="server" ControlToValidate="txtUserID" CssClass="Validation" Display="None" ErrorMessage="User ID must be at least 5 Characters." SetFocusOnError="True"></asp:CustomValidator>
            </p>
            <p id="RFVPassword">
                Password:
                <asp:TextBox ID="txtPassword" runat="server" CssClass="Validation"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RFVLastName0" runat="server" ControlToValidate="txtPassword" CssClass="Validation" Display="None" ErrorMessage="Please enter a Password" SetFocusOnError="True"></asp:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="REVPassword" runat="server" ControlToValidate="txtPassword" CssClass="Validation" Display="None" ErrorMessage="Please enter with two upper case letters  Followed by any one of three symbols (-, *, =) Followed by any four numbers that are between two and eight." SetFocusOnError="True" ValidationExpression="^[A-Z]{2}[=*-][2-8]{4}"></asp:RegularExpressionValidator>
            </p>
            <p>
                Confirm Password:
                <asp:TextBox ID="txtConPassword" runat="server" CssClass="Validation"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RFVConPassword" runat="server" ControlToValidate="txtConPassword" CssClass="Validation" Display="None" ErrorMessage="Please enter a password" SetFocusOnError="True"></asp:RequiredFieldValidator>
                <asp:CompareValidator ID="CVConPassword" runat="server" ControlToCompare="txtPassword" ControlToValidate="txtConPassword" CssClass="Validation" Display="None" ErrorMessage="Password Must Match" SetFocusOnError="True"></asp:CompareValidator>
            </p>
            <asp:ValidationSummary ID="VSErrormess" runat="server" CssClass="Validation" />
        </div>
        <asp:Button ID="btnCreateAccount" runat="server" Text="Create Account" CssClass="Validation" />
&nbsp;<asp:Button ID="btnResetForm" runat="server" CausesValidation="False" Text="Reset Form" CssClass="Validation" />
        <p>
            &nbsp;</p>
    </form>
</body>
</html>
